/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	DeleteLines.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CEdit.h"
#include "CApplication.h"

//	Deletes the given object set

HRESULT DeleteLines(ISet *objectSet1)
{
	
	START_METHOD("DeleteLines")

	HRESULT status = CONV_SUCCESS;
	
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objectSet1));
	CHECK_RETURN_STATUS(status)

	IPartOthers *part1 = CAST(IPartOthers, activePart);

	status = part1->Update(3);
	CHECK_RETURN_STATUS(status)

	// Delete the selection
	status = activeGraphicDoc->DeleteSelection();
	CHECK_RETURN_STATUS(status)

	// Update the views
	status = part1->Update(6);
	CHECK_RETURN_STATUS(status)

	END_METHOD("DeleteLines")
}
